<?= $this-> include('templates/header');?>
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="<?= base_url('ns-admin') ?>"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?= isset($pageTitle) ? esc($pageTitle) : "" ?></li>
            </ol>
        </nav>
        <div class="row g-4">
            <div class="col-12">
                <div class="card h-100">
                    <div class="card-body p-4">
                        <form action="<?= base_url('/ns-admin/create_radio_handler') ?>" name="addeditcounty" method="POST" enctype="multipart/form-data">
                            <input  type="hidden" name="radio_id" value="<?= isset($radio_id) ? esc($radio_id) : "" ?>" />
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Category</label>
                                <div class="col-sm-10">
                                    <select name="cat_id" id="cat_id" class="nsofts-select" required>
                                        <option value="">--Select Category--</option>
                                        <?php foreach($cat_result as $cat_row){ ?>      
                                            <?php if(isset($radio_id)){ ?>
                                                <option value="<?= isset($cat_row['cid']) ? esc($cat_row['cid']) : '' ?>" <?php if($cat_row['cid']==$row['cat_id']){?>selected<?php }?>><?= isset($cat_row['category_name']) ? esc($cat_row['category_name']) : '' ?></option>	          							 
                                            <?php } else { ?>
                                                <option value="<?= isset($cat_row['cid']) ? esc($cat_row['cid']) : '' ?>"><?= isset($cat_row['category_name']) ? esc($cat_row['category_name']) : '' ?></option>   							 
                                            <?php } ?>
                                        <?php } ?> 
                                    </select>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Countries</label>
                                <div class="col-sm-10">
                                    <select name="countries_id" id="countries_id" class="nsofts-select" required>
                                        <option value="">--Select Countries--</option>
                                        <?php foreach($cou_result as $cou_row){ ?>      
                                            <?php if(isset($radio_id)){ ?>
                                                <option value="<?= isset($cou_row['sid']) ? esc($cou_row['sid']) : '' ?>" <?php if($cou_row['sid']==$row['countries_id']){?>selected<?php }?>><?= isset($cou_row['countries_name']) ? esc($cou_row['countries_name']) : '' ?></option>	          							 
                                            <?php } else { ?>
                                                <option value="<?= isset($cou_row['sid']) ? esc($cou_row['sid']) : '' ?>"><?= isset($cou_row['countries_name']) ? esc($cou_row['countries_name']) : '' ?></option>   							 
                                            <?php } ?>
                                        <?php } ?> 
                                    </select>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Radio title</label>
                                <div class="col-sm-10">
                                     <input type="text" name="radio_title" class="form-control" value="<?= isset($radio_id) ? esc($row['radio_title']) : '' ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-2 row">
                                <label class="col-sm-2 col-form-label">Premium</label>
                                <div class="col-sm-10">
                                    <div class="nsofts-switch d-flex align-items-center">
                                        <input type="checkbox" id="isPremium" name="isPremium" value="true" class="cbx hidden" 
                                            <?php if(isset($radio_id)){ ?>
                                                <?php if($row['isPremium']=='true'){ echo 'checked'; }?>
                                            <?php } ?>
                                        />
                                        <label for="isPremium" class="nsofts-switch__label"></label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Radio URL</label>
                                <div class="col-sm-10">
                                     <input type="text" name="radio_url" class="form-control" value="<?= isset($radio_id) ? esc($row['radio_url']) : '' ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Description</label>
                                <div class="col-sm-10">
                                     <textarea name="radio_description" id="radio_description" rows="5" class="nsofts-editor"><?= isset($radio_id) ? esc($row['radio_description']) : '' ?></textarea>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <div class="mb-3 row">
                                    <label class="col-sm-2 col-form-label">Select Image</label>
                                    <div class="col-sm-10">
                                        <input type="file" class="form-control-file" name="image_add" accept=".png, .PNG, .jpg, .JPG, .jpeg, .JPEG, .webp, .WEBP" onchange="fileValidation()" id="fileupload" <?php if(!isset($radio_id)){?>required<?php } ?>>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <div class="mb-3 row">
                                    <label class="col-sm-2 col-form-label">&nbsp;</label>
                                    <div class="col-sm-10">
                                        <div class="fileupload_img" id="imagePreview">
                                            <?php if(isset($radio_id)) {?>
                                              <img class="col-sm-2 img-thumbnail" type="image" src="<?= base_url('images/'.$row['radio_image']) ?>" alt="image" />
                                            <?php } else {?>
                                              <img class="col-sm-2 img-thumbnail" type="image" src="<?= base_url('assets/images/300x300.jpg') ?>" alt="image" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <div class="mb-3 row">
                                    <label class="col-sm-2 col-form-label">&nbsp;</label>
                                    <div class="col-sm-10">
                                        <button type="submit" name="submit" class="btn btn-primary" style="min-width: 120px;"><?=$pageSave?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?= $this-> include('templates/footer');?>